/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsFileDescriptor;
import java.io.File;
import java.text.DateFormat;
import java.util.GregorianCalendar;

public class FsFileFilter {
    protected boolean m_fileTypeSet = false;
    protected boolean m_fileNameSet = false;
    protected boolean m_fileSizeMinimumSet = false;
    protected boolean m_fileSizeMaximumSet = false;
    protected boolean m_fileDateMinimumSet = false;
    protected boolean m_fileDateMaximumSet = false;
    protected int m_fileType = -1;
    protected String m_fileName = null;
    protected long m_fileSizeMinimum = 0L;
    protected long m_fileSizeMaximum = Long.MAX_VALUE;
    protected long m_fileDateMinimumValue = 0L;
    protected long m_fileDateMaximumValue = Long.MAX_VALUE;
    protected GregorianCalendar m_fileDateMinimum = null;
    protected GregorianCalendar m_fileDateMaximum = null;

    public void clear() {
        this.m_fileNameSet = false;
        this.m_fileSizeMinimumSet = false;
        this.m_fileSizeMaximumSet = false;
        this.m_fileDateMinimumSet = false;
        this.m_fileDateMaximumSet = false;
        this.m_fileName = null;
        this.m_fileSizeMinimum = 0L;
        this.m_fileSizeMaximum = Long.MAX_VALUE;
        this.m_fileDateMinimumValue = 0L;
        this.m_fileDateMaximumValue = Long.MAX_VALUE;
        this.m_fileDateMinimum = null;
        this.m_fileDateMaximum = null;
    }

    public GregorianCalendar getDateMaximum() {
        return this.m_fileDateMaximum;
    }

    public String getDateMaximumString() {
        if (this.m_fileDateMaximum != null) {
            return DateFormat.getDateTimeInstance(3, 2).format(this.m_fileDateMaximum.getTime());
        }
        return null;
    }

    public GregorianCalendar getDateMinimum() {
        return this.m_fileDateMinimum;
    }

    public String getDateMinimumString() {
        if (this.m_fileDateMinimum != null) {
            return DateFormat.getDateTimeInstance(3, 2).format(this.m_fileDateMinimum.getTime());
        }
        return null;
    }

    public String getName() {
        return this.m_fileName;
    }

    public long getSizeMaximum() {
        return this.m_fileSizeMaximum;
    }

    public long getSizeMinimum() {
        return this.m_fileSizeMinimum;
    }

    public int getType() {
        return this.m_fileType;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (super.equals(object) && object instanceof FsFileFilter) {
            FsFileFilter fsFileFilter = (FsFileFilter)object;
            return !(this.m_fileTypeSet != fsFileFilter.m_fileTypeSet || this.m_fileTypeSet && this.m_fileType != fsFileFilter.m_fileType || this.m_fileNameSet != fsFileFilter.m_fileNameSet || this.m_fileNameSet && !this.m_fileName.equals(fsFileFilter.m_fileName) || this.m_fileSizeMinimumSet != fsFileFilter.m_fileSizeMinimumSet || this.m_fileSizeMinimumSet && this.m_fileSizeMinimum != fsFileFilter.m_fileSizeMinimum || this.m_fileSizeMaximumSet != fsFileFilter.m_fileSizeMaximumSet || this.m_fileSizeMaximumSet && this.m_fileSizeMinimum != fsFileFilter.m_fileSizeMinimum || this.m_fileDateMinimumSet != fsFileFilter.m_fileDateMinimumSet || this.m_fileDateMinimumSet && this.m_fileDateMinimumValue != fsFileFilter.m_fileDateMinimumValue || this.m_fileDateMaximumSet != fsFileFilter.m_fileDateMaximumSet || this.m_fileDateMaximumSet && this.m_fileDateMaximumValue != fsFileFilter.m_fileDateMaximumValue);
        }
        return false;
    }

    public boolean isDateMaximumSet() {
        return this.m_fileDateMaximumSet;
    }

    public boolean isDateMinimumSet() {
        return this.m_fileDateMaximumSet;
    }

    public boolean isNameSet() {
        return this.m_fileNameSet;
    }

    public boolean isSizeMaximumSet() {
        return this.m_fileSizeMaximumSet;
    }

    public boolean isSizeMinimumSet() {
        return this.m_fileSizeMinimumSet;
    }

    public boolean isTypeSet() {
        return this.m_fileTypeSet;
    }

    public boolean match(FsFileDescriptor fsFileDescriptor) {
        String string;
        if (fsFileDescriptor == null) {
            return false;
        }
        if (this.m_fileTypeSet && this.m_fileType == 1 && ((string = fsFileDescriptor.getName()) == null || string.length() < 8 || !fsFileDescriptor.getName().substring(0, 8).equals("SYSDUMP."))) {
            return false;
        }
        if (this.m_fileNameSet && fsFileDescriptor.getName().indexOf(this.m_fileName) < 0) {
            return false;
        }
        if (this.m_fileNameSet && fsFileDescriptor.getName().indexOf(this.m_fileName) < 0) {
            return false;
        }
        long l = fsFileDescriptor.getSize();
        if (l < this.m_fileSizeMinimum || this.m_fileSizeMaximum < l) {
            return false;
        }
        long l2 = fsFileDescriptor.getTime();
        return l2 > this.m_fileDateMinimumValue && this.m_fileDateMaximumValue > l2;
    }

    public boolean match(File file) {
        return this.match(new FsFileDescriptor(file));
    }

    public void setDateMaximum(GregorianCalendar gregorianCalendar) {
        this.m_fileDateMaximum = gregorianCalendar;
        this.m_fileDateMaximumValue = gregorianCalendar != null ? gregorianCalendar.getTime().getTime() : Long.MAX_VALUE;
        this.m_fileDateMaximumSet = true;
    }

    public void setDateMinimum(GregorianCalendar gregorianCalendar) {
        this.m_fileDateMinimum = gregorianCalendar;
        this.m_fileDateMinimumValue = gregorianCalendar != null ? gregorianCalendar.getTime().getTime() : 0L;
        this.m_fileDateMinimumSet = true;
    }

    public void setName(String string) {
        this.m_fileName = string;
        this.m_fileNameSet = true;
    }

    public void setSizeMaximum(long l) {
        this.m_fileSizeMaximum = l;
        this.m_fileSizeMaximumSet = true;
    }

    public void setSizeMinimum(long l) {
        this.m_fileSizeMinimum = l;
        this.m_fileSizeMinimumSet = true;
    }

    public void setType(int n) {
        this.m_fileType = n;
        if (n == 1) {
            this.m_fileTypeSet = true;
        }
    }
}

